/*-------------------------------------------------------*
*  Name:      ViewsPreset.zmp                            *
*  Purpose:   Demonstration only                         *
*  Authors:   Oleg M.                                    *
*                                                        *
*  History:   2.October.01 - project started             *
*                                                        *
*-------------------------------------------------------*/
#include <struct.h>
#include "CViewsBar.h"

DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING |
    Z3D_PLUGSUPPORTS_SCENEOPENSAVE;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 0;
}

DWORD CALLBACK GetProcsAmount(long)
{
  return 1;
}

DWORD CALLBACK PlaceType(long num)
{
  return Z3D_PROCPLACE_FLOATBAR;
}

char* CALLBACK GetProcName(long num)
{
  return "Views Preset Bar";
}

char* CALLBACK GetMenuFolder(long num)
{
  return "Tutorials\0";
}

//----------------------------------------------------
CViewsBar* pViewsBar;

DWORD CALLBACK ViewsPresetsClear(
  tProcParams* params)
{
  pViewsBar->ReleaseList();
  return 0;
}

DWORD CALLBACK OnLoadFloatBar(
            DWORD        num,
            CRollUpBar**    DB,
            CWnd        *pwnd,
            HINSTANCE      AppHandle,
            HINSTANCE      DLLHandle)
{
  if (DLLHandle && pwnd)
  {
    AfxSetResourceHandle(DLLHandle);// Tell system to use DLL's resources.
    pViewsBar = new CViewsBar(pwnd);
    if (pViewsBar)
    {
      pViewsBar->EnableDocking(0);//not dockable
      pViewsBar->ShowWindow(SW_HIDE);
      CurrentState.CurrentParams.ListSet->AddProc(
        Z3D_EVENT_SCENENEW | Z3D_EVENT_SCENEOPEN,
        "Views Presets Clear",
        (PLUGPROCESSORPROC)ViewsPresetsClear,
        NULL,
        NULL,
        NULL,
        &CurrentState.CurrentParams,
        CurrentState.CurrentParams.DllHandle);

    }
    AfxSetResourceHandle(AppHandle);// Set it back before leaving.
  }
  else
  {
    pwnd->MessageBox("Resources not found or Editor window was not created!","Internal Error:", MB_OK | MB_ICONEXCLAMATION);
    pViewsBar = NULL;
    return 0;
  }

  if (pViewsBar) *DB = pViewsBar;
  return 1;
}


DWORD CALLBACK ReadChunk(tProcParams* params)
{
  if (0x1001 == params->reserv)
  {
    CFile* pFile = (CFile*)params->pDATA;
    if (!pFile) return 0;
    return pViewsBar->ReadFromFile(pFile);
  }
  return 0;
}


DWORD CALLBACK WriteChunks(tProcParams* params)
{
  CFile* pFile = (CFile*)params->pDATA;
  if (!pFile) return 0;

  return pViewsBar->WriteToFile(pFile);
}
